<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'middle_name', 'last_name', 'sex', 'birth_date', 'join_at', 'position');

    public function getTeacher()
    {
        return $this->hasOne('App\Model\Teacher');
    }

}